unit IWCompProgressBar;
{PUBDIST}

interface

uses
  {$IFDEF VSNET}System.ComponentModel, System.Drawing, {$ENDIF}
  Classes,
  IWControl, IWColor, IWHTMLTag, IWRenderContext;

type
  {$IFDEF VSNET}
  {$R icons\Atozed.Intraweb.TIWProgressBar.bmp}
  TIWProgressBar = class;
  [ToolboxItem(true), ToolboxBitmap(typeof(TIWProgressBar), 'TIWProgressBar.bmp')]
  {$ENDIF}
  TIWProgressBar = class(TIWCustomControl)
  protected
    FBGColor: TIWColor;
    FPercent: Integer;
    FShowText: Boolean;

    procedure SetBGColor(const Value: TIWColor);
    procedure SetPercent(const Value: Integer);
    procedure InitControl; override;
  public
    function RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag; override;
  published
    property BGColor: TIWColor read FBGColor write SetBGColor;
    property FriendlyName;
    {$IFDEF CLR}
    property WebColor;
    property WebFont;
    {$ELSE}
    property Color;
    property Font;
    {$ENDIF}
    property Percent: Integer read FPercent write SetPercent;
    property ShowText: Boolean read FShowText write FShowText;
  end;

implementation

uses
  {$IFDEF Linux}QGraphics,{$ELSE}Graphics,{$ENDIF}
  SysUtils;

{ TIWProgressBar }

procedure TIWProgressBar.InitControl;
begin
  inherited;
  BGColor := fromTColor(clLtGray);
  WebColor := fromTColor(clBlue);
  Height := 17;
  Width := 225;
end;

function TIWProgressBar.RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag;
begin
  Result := TIWHTMLTag.CreateTag('TABLE');
  try
    with Result do
    begin
      AddIntegerParam('cellpadding', 0);
      AddIntegerParam('cellspacing', 0);
      with Contents.AddTag('TR') do
      begin
        with Contents.AddTag('TD') do
        begin
          AddStringParam('bgcolor', ColorToRGBString(BGColor));
          AddIntegerParam('width', Width);
          AddIntegerParam('height', Height);
          with Contents.AddTag('TABLE') do
          begin
            AddIntegerParam('cellpadding', 0);
            AddIntegerParam('cellspacing', 0);
            AddStringParam('width', '100%');
            AddIntegerParam('height', Height);
            with Contents.AddTag('TR') do
            begin
              with Contents.AddTag('TD') do
              begin
                AddStringParam('align', 'center');
                AddStringParam('valign', 'middlev');

                // 0% and 0 produce bad rendering but we have to render in case of text
                if Percent > 0 then
                begin
                  AddStringParam('width', IntToStr(Percent) + '%');
                  AddStringParam('bgcolor', ColorToRGBString(WebColor));
                end
                else
                begin
                  AddIntegerParam('width', 1);
                end;
                AddStringParam('height', '100%');
                if ShowText then
                begin
                  Contents.AddTagAsObject(WebFont.FontToStringTag(IntToStr(Percent) + '%'));
                end
                else
                begin
                  Contents.AddText('&nbsp;');
                end;
              end;
              if Percent <> 100 then
              begin
                with Contents.AddTag('TD') do
                begin
                  Contents.AddText('&nbsp;');
                end;
              end;
            end;
          end;
        end;
      end;
    end;
  except
    FreeAndNil(Result);
    raise;
  end;
end;

procedure TIWProgressBar.SetBGColor(const Value: TIWColor);
begin
  if FBGColor <> Value then begin
    FBGColor := Value;
    Invalidate;
  end;
end;

procedure TIWProgressBar.SetPercent(const Value: Integer);
begin
  if FPercent <> Value then begin
    FPercent := Value;
    Invalidate;
  end;
end;

end.
